/*
 * Copyright 2009-2024 PrimeTek.
 *
 * https://www.primefaces.org/lts/licenses/
 *
 * Licensed under PrimeFaces Commercial License, Version 1.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * Licensed under PrimeFaces Commercial License, Version 1.0 (the "License");
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.primefaces.selenium.internal;

import org.openqa.selenium.WebElement;
import org.openqa.selenium.support.events.WebDriverListener;
import org.primefaces.selenium.PrimeSelenium;

public class ScrollElementIntoViewClickListener implements WebDriverListener {

    private String option;

    public ScrollElementIntoViewClickListener() {

    }

    public ScrollElementIntoViewClickListener(String option) {
        this.option = option;
    }

    @Override
    public void beforeClick(WebElement element) {
        if (!PrimeSelenium.isElementDisplayed(element) || PrimeSelenium.isVisibleInViewport(element)) {
            return;
        }

        // Rely on scrolling through JS
        // this will try to align the top of the element to the top of the window and
        // completely avoid collisions with the navigationbar
        // See:
        // https://developer.mozilla.org/de/docs/Web/API/Element/scrollIntoView
        // https://www.w3.org/TR/webdriver/#dfn-scrolls-into-view
        PrimeSelenium.executeScript("arguments[0].scrollIntoView(" + option + ")", element);
    }
}
