/*
 * Copyright 2009-2024 PrimeTek.
 *
 * https://www.primefaces.org/lts/licenses/
 *
 * Licensed under PrimeFaces Commercial License, Version 1.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * Licensed under PrimeFaces Commercial License, Version 1.0 (the "License");
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.primefaces.selenium;

import org.openqa.selenium.WebDriver;
import org.openqa.selenium.html5.WebStorage;
import org.primefaces.selenium.spi.WebDriverProvider;

public abstract class AbstractPrimePage {

    private WebDriver webDriver;

    public String getBaseLocation() {
        return null;
    }

    public abstract String getLocation();

    public void goTo() {
        PrimeSelenium.goTo(this);
    }

    public boolean isAt() {
        return WebDriverProvider.get().getCurrentUrl().contains(getLocation());
    }

    public WebDriver getWebDriver() {
        return webDriver;
    }

    public void setWebDriver(WebDriver webDriver) {
        this.webDriver = webDriver;
    }

    /**
     * Get WebStorage of WebDriver.
     *
     * @return Returns WebStorage of WebDriver when this feature is supported by the browser. Some browsers like Safari (as of january 2021) do not support
     *         WebStorage via WebDriver. In this case null is returned.
     */
    public WebStorage getWebStorage() {
        return PrimeSelenium.getWebStorage();
    }
}
