/*
 * Decompiled with CFR 0.152.
 */
package org.primefaces.selenium.component.base;

import org.json.JSONObject;
import org.openqa.selenium.WebElement;
import org.primefaces.selenium.AbstractPrimePageFragment;
import org.primefaces.selenium.PrimeSelenium;
import org.primefaces.selenium.component.base.ComponentUtils;

public abstract class AbstractComponent
extends AbstractPrimePageFragment {
    private static final String CSP_SCRIPT = "return PrimeFaces.csp.hasRegisteredAjaxifiedEvent('%s', '%s');";

    public String getWidgetByIdScript() {
        return ComponentUtils.getWidgetByIdScript(this.getId());
    }

    public String getWidgetConfigurationAsString() {
        return ComponentUtils.getWidgetConfiguration(this.getRoot());
    }

    public JSONObject getWidgetConfiguration() {
        String cfg = this.getWidgetConfigurationAsString();
        if (cfg == null || cfg.length() == 0) {
            return null;
        }
        return new JSONObject(cfg);
    }

    protected boolean isAjaxified(String event) {
        return this.isAjaxified(this.getRoot(), event);
    }

    protected boolean isAjaxified(WebElement element, String event) {
        boolean isAjaxScript;
        if (element == null) {
            element = this.getRoot();
        }
        if (isAjaxScript = ComponentUtils.isAjaxScript(element.getAttribute(event))) {
            return true;
        }
        String id = element.getAttribute("id");
        String cspScript = String.format(CSP_SCRIPT, id, event);
        return (Boolean)PrimeSelenium.executeScript((String)cspScript, (Object[])new Object[0]);
    }

    public void destroy() {
        PrimeSelenium.executeScript((String)(this.getWidgetByIdScript() + ".destroy();"), (Object[])new Object[0]);
    }
}

