/*
 * Copyright 2009-2024 PrimeTek.
 *
 * https://www.primefaces.org/lts/licenses/
 *
 * Licensed under PrimeFaces Commercial License, Version 1.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * Licensed under PrimeFaces Commercial License, Version 1.0 (the "License");
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.primefaces.selenium.component.model.treetable;

import org.openqa.selenium.By;
import org.openqa.selenium.WebElement;
import org.primefaces.selenium.PrimeSelenium;
import org.primefaces.selenium.component.model.datatable.Cell;

import java.util.Arrays;
import java.util.List;
import java.util.Optional;

public class Row extends org.primefaces.selenium.component.model.datatable.Row {

    public Row(WebElement webElement, List<Cell> cells) {
        super(webElement, cells);
    }

    public boolean isToggleable() {
        return (getToggler() != null);
    }

    public void toggle() {
        if (isToggleable()) {
            PrimeSelenium.guardAjax(getToggler()).click();
        }
    }

    private WebElement getToggler() {
        return getCell(0).getWebElement().findElement(By.className("ui-treetable-toggler"));
    }

    public int getLevel() {
        String cssClasses = getWebElement().getAttribute("class");
        Optional<String> levelClassOpt = Arrays.stream(cssClasses.split(" ")).filter(c -> c.startsWith("ui-node-level")).findFirst();
        if (levelClassOpt.isPresent()) {
            String levelClass = levelClassOpt.get();
            return Integer.parseInt(levelClass.replace("ui-node-level-", ""));
        }
        else {
            return -1;
        }
    }
}
