/*
 * Copyright 2009-2024 PrimeTek.
 *
 * https://www.primefaces.org/lts/licenses/
 *
 * Licensed under PrimeFaces Commercial License, Version 1.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * Licensed under PrimeFaces Commercial License, Version 1.0 (the "License");
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.primefaces.selenium.component;

import org.openqa.selenium.By;
import org.openqa.selenium.NoSuchElementException;
import org.openqa.selenium.StaleElementReferenceException;
import org.openqa.selenium.WebElement;
import org.primefaces.selenium.component.base.AbstractComponent;

/**
 * Component wrapper for the PrimeFaces {@code p:outputLabel}.
 */
public abstract class OutputLabel extends AbstractComponent {

    /**
     * Does this outputLabel have the * required indicator?
     *
     * @return true if has required indicator false if not
     */
    public boolean hasRequiredIndicator() {
        try {
            findElement(By.className("ui-outputlabel-rfi"));
            return true;
        }
        catch (NoSuchElementException | StaleElementReferenceException e) {
            return false;
        }
    }

    /**
     * Gets the component this label is for.
     *
     * @return the {@link WebElement} this label is for or NULL if not for any
     */
    public WebElement getFor() {
        try {
            return getWebDriver().findElement(By.id(getAttribute("for")));
        }
        catch (NoSuchElementException | StaleElementReferenceException e) {
            return null;
        }
    }

}
