/*
 * Copyright 2009-2024 PrimeTek.
 *
 * https://www.primefaces.org/lts/licenses/
 *
 * Licensed under PrimeFaces Commercial License, Version 1.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * Licensed under PrimeFaces Commercial License, Version 1.0 (the "License");
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.primefaces.selenium.component;

import org.openqa.selenium.WebElement;
import org.openqa.selenium.support.FindBy;
import org.primefaces.selenium.component.base.AbstractComponent;

/**
 * Component wrapper for the PrimeFaces {@code p:message}.
 */
public abstract class Message extends AbstractComponent {

    @FindBy(css = ".ui-message-error-icon")
    private WebElement iconError;
    @FindBy(css = ".ui-message-info-icon")
    private WebElement iconInfo;
    @FindBy(css = ".ui-message-warn-icon")
    private WebElement iconWarn;
    @FindBy(css = ".ui-message-fatal-icon")
    private WebElement iconFatal;
    @FindBy(css = ".ui-message-error-summary")
    private WebElement summaryError;
    @FindBy(css = ".ui-message-info-summary")
    private WebElement summaryInfo;
    @FindBy(css = ".ui-message-warn-summary")
    private WebElement summaryWarn;
    @FindBy(css = ".ui-message-fatal-summary")
    private WebElement summaryFatal;
    @FindBy(css = ".ui-message-error-detail")
    private WebElement detailError;
    @FindBy(css = ".ui-message-info-detail")
    private WebElement detailInfo;
    @FindBy(css = ".ui-message-warn-detail")
    private WebElement detailWarn;
    @FindBy(css = ".ui-message-fatal-detail")
    private WebElement detailFatal;

    public WebElement getIconError() {
        return iconError;
    }
    public WebElement getIconInfo() {
        return iconInfo;
    }
    public WebElement getIconWarn() {
        return iconWarn;
    }
    public WebElement getIconFatal() {
        return iconFatal;
    }
    public WebElement getDetailError() {
        return detailError;
    }
    public WebElement getDetailInfo() {
        return detailInfo;
    }
    public WebElement getDetailWarn() {
        return detailWarn;
    }
    public WebElement getDetailFatal() {
        return detailFatal;
    }
    public WebElement getSummaryError() {
        return summaryError;
    }
    public WebElement getSummaryInfo() {
        return summaryInfo;
    }
    public WebElement getSummaryWarn() {
        return summaryWarn;
    }
    public WebElement getSummaryFatal() {
        return summaryFatal;
    }
}
