/*
 * Copyright 2009-2024 PrimeTek.
 *
 * https://www.primefaces.org/lts/licenses/
 *
 * Licensed under PrimeFaces Commercial License, Version 1.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * Licensed under PrimeFaces Commercial License, Version 1.0 (the "License");
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.primefaces.selenium.component;

import java.util.List;

import org.openqa.selenium.By;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.support.FindBy;
import org.primefaces.selenium.component.base.AbstractPageableData;

/**
 * @deprecated since 10.0 and removal possible anytime after that
 */
@Deprecated
public abstract class DataList extends AbstractPageableData {

    @FindBy(className = "ui-datalist-content")
    private WebElement content;

    @Override
    public List<WebElement> getRowsWebElement() {
        return content.findElements(By.className("ui-datalist-item"));
    }

    public WebElement getRowWebElement(int index) {
        return getRowsWebElement().get(index);
    }

}
