/*
 * Copyright 2009-2024 PrimeTek.
 *
 * https://www.primefaces.org/lts/licenses/
 *
 * Licensed under PrimeFaces Commercial License, Version 1.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * Licensed under PrimeFaces Commercial License, Version 1.0 (the "License");
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.primefaces.selenium.component;

import org.openqa.selenium.WebElement;
import org.openqa.selenium.support.FindBy;

/**
 * Component wrapper for the PrimeFaces {@code p:confirmDialog}.
 */
public abstract class ConfirmDialog extends Dialog {

    @FindBy(className = "ui-confirm-dialog-severity")
    private WebElement icon;

    @FindBy(className = "ui-confirm-dialog-message")
    private WebElement message;

    @FindBy(className = "ui-confirmdialog-yes")
    private CommandButton yesButton;

    @FindBy(className = "ui-confirmdialog-no")
    private CommandButton noButton;

    public WebElement getMessage() {
        return message;
    }

    public WebElement getIcon() {
        return icon;
    }

    public CommandButton getYesButton() {
        return yesButton;
    }

    public CommandButton getNoButton() {
        return noButton;
    }

}
