/*
 * Copyright 2009-2024 PrimeTek.
 *
 * https://www.primefaces.org/lts/licenses/
 *
 * Licensed under PrimeFaces Commercial License, Version 1.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * Licensed under PrimeFaces Commercial License, Version 1.0 (the "License");
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.primefaces.selenium.component;

import org.openqa.selenium.WebElement;
import org.openqa.selenium.support.ui.ExpectedConditions;
import org.primefaces.selenium.PrimeExpectedConditions;
import org.primefaces.selenium.PrimeSelenium;
import org.primefaces.selenium.component.html.Link;

/**
 * Component wrapper for the PrimeFaces {@code p:commandLink}.
 */
public abstract class CommandLink extends Link {

    @Override
    public void click() {
        WebElement link = getRoot();
        PrimeSelenium.waitGui().until(PrimeExpectedConditions.visibleAndAnimationComplete(link));
        PrimeSelenium.waitGui().until(ExpectedConditions.elementToBeClickable(link));

        if (link.getAttribute("data-pfconfirmcommand") != null) {
            // Confirm Dialog/Popup we don't want to guard for AJAX
        }
        else if (isAjaxified("onclick")) {
            link = PrimeSelenium.guardAjax(link);
        }
        else if ("_blank".equals(link.getAttribute("target"))) {
            link = PrimeSelenium.guardHttp(link);
        }

        link.click();
    }

    /**
     * #8840 Some scenario's with ajax="false" like in a download you may not want to guard the click.
     */
    public void clickUnguarded() {
        WebElement link = getRoot();
        PrimeSelenium.waitGui().until(ExpectedConditions.elementToBeClickable(link));
        link.click();
    }
}
