/*
 * Copyright 2009-2024 PrimeTek.
 *
 * https://www.primefaces.org/lts/licenses/
 *
 * Licensed under PrimeFaces Commercial License, Version 1.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * Licensed under PrimeFaces Commercial License, Version 1.0 (the "License");
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.primefaces.selenium.component.model.tree;

import org.openqa.selenium.By;
import org.openqa.selenium.WebElement;
import org.primefaces.selenium.PrimeSelenium;
import org.primefaces.selenium.component.Tree;

import java.util.List;
import java.util.stream.Collectors;

public class TreeNode {

    private WebElement webElement;
    private TreeNode parent;
    private Tree tree;
    private String selector;
    private String childSelector;

    public TreeNode(WebElement webElement, String selector, Tree tree) {
        this.webElement = webElement;
        this.selector = selector;
        this.childSelector = selector + ">.ui-treenode-children>.ui-treenode";
        this.tree = tree;
    }

    public TreeNode(WebElement webElement, String selector, TreeNode parent) {
        this.webElement = webElement;
        this.selector = selector;
        this.childSelector = selector + ">.ui-treenode-children>.ui-treenode";
        this.parent = parent;
        this.tree = parent.getTree();
    }

    public WebElement getWebElement() {
        return webElement;
    }

    public void setWebElement(WebElement webElement) {
        this.webElement = webElement;
    }

    public Tree getTree() {
        return tree;
    }

    public TreeNode getParent() {
        return parent;
    }

    public String getSelector() {
        return selector;
    }

    public void setSelector(String selector) {
        this.selector = selector;
    }

    public void toggle() {
        PrimeSelenium.guardAjax(getTreeToggler()).click();
    }

    public void select() {
        // TODO: we are only allowed to guardAjax if select/unselect is ajaxified!
        PrimeSelenium.guardAjax(getLabel()).click();
    }

    public WebElement getTreeToggler() {
        return webElement.findElement(By.cssSelector(".ui-treenode-content .ui-tree-toggler"));
    }

    public String getLabelText() {
        return getLabel().getText();
    }

    public WebElement getLabel() {
        return webElement.findElement(By.cssSelector(".ui-treenode-content .ui-treenode-label"));
    }

    public List<TreeNode> getChildren() {
        return webElement.findElements(By.cssSelector(childSelector)).stream().map(e -> new TreeNode(e, childSelector, this))
                    .collect(Collectors.toList());
    }

}
