/*
 * Copyright 2009-2024 PrimeTek.
 *
 * https://www.primefaces.org/lts/licenses/
 *
 * Licensed under PrimeFaces Commercial License, Version 1.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * Licensed under PrimeFaces Commercial License, Version 1.0 (the "License");
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.primefaces.selenium.component.model.datatable;

import java.util.List;
import java.util.Optional;

import org.openqa.selenium.WebElement;

public class Header {

    private WebElement webElement;
    private List<HeaderCell> cells;

    public Header(WebElement webElement, List<HeaderCell> cells) {
        this.webElement = webElement;
        this.cells = cells;
    }

    public WebElement getWebElement() {
        return webElement;
    }

    public void setWebElement(WebElement webElement) {
        this.webElement = webElement;
    }

    public List<HeaderCell> getCells() {
        return cells;
    }

    public void setCells(List<HeaderCell> cells) {
        this.cells = cells;
    }

    public HeaderCell getCell(int index) {
        return getCells().get(index);
    }

    public Optional<HeaderCell> getCell(String headerText) {
        return getCells().stream()
                    .filter(cell -> headerText.equals(cell.getColumnTitle().getText()))
                    .findFirst();
    }
}
