/*
 * Copyright 2009-2024 PrimeTek.
 *
 * https://www.primefaces.org/lts/licenses/
 *
 * Licensed under PrimeFaces Commercial License, Version 1.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * Licensed under PrimeFaces Commercial License, Version 1.0 (the "License");
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.primefaces.selenium.component.html;

import org.primefaces.selenium.PrimeSelenium;
import org.primefaces.selenium.component.base.AbstractComponent;

public abstract class Link extends AbstractComponent {

    @Override
    public void click() {
        String href = getHref();
        String target = getTarget();

        if ("_blank".equals(target) || (href != null && href.startsWith("#"))) {
            getRoot().click();
        }
        else {
            PrimeSelenium.guardHttp(getRoot()).click();
        }
    }

    public String getHref() {
        return getRoot().getAttribute("href");
    }

    public String getTarget() {
        return getRoot().getAttribute("target");
    }
}