/*
 * Copyright 2009-2024 PrimeTek.
 *
 * https://www.primefaces.org/lts/licenses/
 *
 * Licensed under PrimeFaces Commercial License, Version 1.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * Licensed under PrimeFaces Commercial License, Version 1.0 (the "License");
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.primefaces.selenium.component.base;

import java.util.List;
import org.openqa.selenium.By;

import org.openqa.selenium.WebElement;
import org.openqa.selenium.support.FindBy;
import org.openqa.selenium.support.ui.Select;
import org.primefaces.selenium.PrimeSelenium;
import org.primefaces.selenium.component.model.data.Page;
import org.primefaces.selenium.component.model.data.Paginator;

public abstract class AbstractPageableData extends AbstractComponent {

    @FindBy(className = "ui-paginator")
    private WebElement paginator;

    public abstract List<WebElement> getRowsWebElement();

    public WebElement getPaginatorWebElement() {
        return paginator;
    }

    public Paginator getPaginator() {
        return new Paginator(getPaginatorWebElement());
    }

    public void selectPage(Page page) {
        Page activePage = getPaginator().getActivePage();

        if (activePage != null && activePage.getNumber() == page.getNumber()) {
            // we are already on the right page
        }
        else {
            PrimeSelenium.guardAjax(page.getWebElement()).click();
        }
    }

    public void selectPage(int number) {
        for (Page page : getPaginator().getPages()) {
            if (page.getNumber() == number) {
                selectPage(page);
                break;
            }
        }
    }

    public void selectRowsPerPage(int rows) {
        WebElement rppDD = getWebDriver().findElement(By.name(this.getId() + "_rppDD"));
        PrimeSelenium.guardAjax(new Select(rppDD)).selectByValue("" + rows);
    }
}
