/*
 * Copyright 2009-2024 PrimeTek.
 *
 * https://www.primefaces.org/lts/licenses/
 *
 * Licensed under PrimeFaces Commercial License, Version 1.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * Licensed under PrimeFaces Commercial License, Version 1.0 (the "License");
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.primefaces.selenium.component;

import java.util.List;
import java.util.stream.Collectors;

import org.openqa.selenium.By;
import org.primefaces.selenium.component.base.AbstractComponent;
import org.primefaces.selenium.component.model.tree.TreeNode;

/**
 * Component wrapper for the PrimeFaces {@code p:tree}.
 */
public abstract class Tree extends AbstractComponent {

    public static final String CONTAINER_CLASS = "ui-tree";
    public static final String ROOT_NODES_CLASS = "ui-tree-container";
    public static final String TREE_NODE_CLASS = "ui-treenode";
    public static final String PARENT_NODE_CLASS = "ui-treenode-parent";
    public static final String CHILDREN_NODES_CLASS = "ui-treenode-children";
    public static final String NODE_CONTENT_CLASS = "ui-treenode-content";
    public static final String LEAF_NODE_CLASS = "ui-treenode-leaf";

    public static final String CHILD_SELECTOR = ".ui-tree-container>.ui-treenode";

    public List<TreeNode> getChildren() {
        return findElements(By.cssSelector(CHILD_SELECTOR)).stream().map(e -> new TreeNode(e, CHILD_SELECTOR, this))
                    .collect(Collectors.toList());
    }

}
