/*
 * Copyright 2009-2024 PrimeTek.
 *
 * https://www.primefaces.org/lts/licenses/
 *
 * Licensed under PrimeFaces Commercial License, Version 1.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * Licensed under PrimeFaces Commercial License, Version 1.0 (the "License");
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.primefaces.selenium.component;

import org.openqa.selenium.By;
import org.openqa.selenium.WebElement;
import org.primefaces.selenium.PrimeSelenium;
import org.primefaces.selenium.component.base.AbstractToggleComponent;

/**
 * Component wrapper for the PrimeFaces {@code p:selectBooleanButton}.
 */
public abstract class SelectBooleanButton extends AbstractToggleComponent {

    /**
     * Gets the current label on the button.
     *
     * @return the label text of the button
     */
    public String getLabel() {
        WebElement label = findElement(By.className("ui-button-text"));
        if (PrimeSelenium.isElementDisplayed(label)) {
            return label.getText();
        }
        return label.getAttribute("textContent");
    }

}
