/*
 * Copyright 2009-2024 PrimeTek.
 *
 * https://www.primefaces.org/lts/licenses/
 *
 * Licensed under PrimeFaces Commercial License, Version 1.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * Licensed under PrimeFaces Commercial License, Version 1.0 (the "License");
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.primefaces.selenium.component;

import org.openqa.selenium.WebElement;
import org.primefaces.selenium.PrimeSelenium;
import org.primefaces.selenium.component.base.AbstractComponent;
import org.primefaces.selenium.component.base.ComponentUtils;
import org.primefaces.selenium.findby.FindByParentPartialId;

/**
 * Component wrapper for the PrimeFaces {@code p:panel}.
 */
public abstract class Panel extends AbstractComponent {

    @FindByParentPartialId("_toggler")
    private WebElement toggler;

    @FindByParentPartialId("_header")
    private WebElement header;

    @FindByParentPartialId("_content")
    private WebElement content;

    public WebElement getToggler() {
        return toggler;
    }

    public WebElement getContent() {
        return content;
    }

    public WebElement getHeader() {
        return header;
    }

    /**
     * Is this component AJAX enabled with "toggle"?
     *
     * @return true if AJAX enabled false if not
     */
    public boolean isToggleAjaxified() {
        return ComponentUtils.hasAjaxBehavior(getRoot(), "toggle");
    }

    /**
     * Is this component AJAX enabled with "close"?
     *
     * @return true if AJAX enabled false if not
     */
    public boolean isCloseAjaxified() {
        return ComponentUtils.hasAjaxBehavior(getRoot(), "close");
    }

    public void close() {
        PrimeSelenium.executeScript(isCloseAjaxified(), getWidgetByIdScript() + ".close();");
    }

    public void expand() {
        PrimeSelenium.executeScript(isToggleAjaxified(), getWidgetByIdScript() + ".expand();");
    }

    public void collapse() {
        PrimeSelenium.executeScript(isToggleAjaxified(), getWidgetByIdScript() + ".collapse();");
    }

    public void toggle() {
        PrimeSelenium.executeScript(isToggleAjaxified(), getWidgetByIdScript() + ".toggle();");
    }
}
