/*
 * Copyright 2009-2024 PrimeTek.
 *
 * https://www.primefaces.org/lts/licenses/
 *
 * Licensed under PrimeFaces Commercial License, Version 1.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * Licensed under PrimeFaces Commercial License, Version 1.0 (the "License");
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.primefaces.selenium.component;

import java.io.Serializable;

import org.openqa.selenium.Keys;
import org.primefaces.selenium.PrimeSelenium;
import org.primefaces.selenium.component.base.AbstractInputComponent;
import org.primefaces.selenium.component.base.ComponentUtils;

/**
 * Component wrapper for the PrimeFaces {@code p:inputText}.
 */
public abstract class InputText extends AbstractInputComponent {

    public String getValue() {
        return getInput().getAttribute("value");
    }

    public void setValue(Serializable value) {
        boolean ajaxified = isOnchangeAjaxified();
        String oldValue = getValue();
        if (oldValue != null && oldValue.length() > 0) {
            if (ajaxified) {
                PrimeSelenium.guardAjax(getInput()).clear();
            }
            else {
                getInput().clear();
            }
        }

        ComponentUtils.sendKeys(getInput(), value.toString());

        if (ajaxified) {
            PrimeSelenium.guardAjax(getInput()).sendKeys(Keys.TAB);
        }
        else {
            getInput().sendKeys(Keys.TAB);
        }
    }
}
