/*
 * Copyright 2009-2024 PrimeTek.
 *
 * https://www.primefaces.org/lts/licenses/
 *
 * Licensed under PrimeFaces Commercial License, Version 1.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * Licensed under PrimeFaces Commercial License, Version 1.0 (the "License");
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.primefaces.selenium.component;

import org.openqa.selenium.WebElement;
import org.openqa.selenium.support.FindBy;
import org.primefaces.selenium.PrimeExpectedConditions;
import org.primefaces.selenium.PrimeSelenium;
import org.primefaces.selenium.component.base.AbstractComponent;

/**
 * Component wrapper for the PrimeFaces {@code p:confirmPopup}.
 */
public abstract class ConfirmPopup extends AbstractComponent {

    @FindBy(className = "ui-confirm-popup-icon")
    private WebElement icon;

    @FindBy(className = "ui-confirm-popup-message")
    private WebElement message;

    @FindBy(className = "ui-confirm-popup-yes")
    private CommandButton yesButton;

    @FindBy(className = "ui-confirm-popup-no")
    private CommandButton noButton;

    public WebElement getMessage() {
        return message;
    }

    public WebElement getIcon() {
        return icon;
    }

    public CommandButton getYesButton() {
        return yesButton;
    }

    public CommandButton getNoButton() {
        return noButton;
    }

    /**
     * Is the popup currently visible.
     *
     * @return true if visible false if not
     */
    public boolean isVisible() {
        return PrimeSelenium.executeScript("return " + getWidgetByIdScript() + ".isVisible();");
    }

    /**
     * Hides the overlay panel.
     */
    public void hidePopup() {
        if (isEnabled() && isDisplayed()) {
            PrimeSelenium.executeScript(getWidgetByIdScript() + ".hide();");
            PrimeSelenium.waitGui().until(PrimeExpectedConditions.invisibleAndAnimationComplete(this));
        }
    }

}
